/*******************************************************************************
* Device      : AD18F08
* Author      : Sunwangzhi
* Version     : V0.0.1
* Date        : 2022.3.24
* Description : 可配置Timer2的预分频和后分频
********************************************************************************/

#include "AD18F08.h"


/******************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_OFF         :  LVR使能位
* _LVT24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_2T          :  选择指令周期为2T模式
* _WDTE_OFF        :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位

*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
******************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_2T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                       );


#define       T2_CKPS_1             0    //TIMER2输入时钟1:1分频
#define       T2_CKPS_4             1    //TIMER2输入时钟1:4分频
#define       T2_CKPS_8             2    //TIMER2输入时钟1:8分频
#define       T2_CKPS_16            3    //TIMER2输入时钟1:16分频
#define       T2_OUTPS_1            0    //TIMER2输入时钟1:1后分频
#define       T2_OUTPS_2            1    //TIMER2输入时钟1:2后分频
#define       T2_OUTPS_3            2    //TIMER2输入时钟1:3后分频
#define       T2_OUTPS_4            3    //TIMER2输入时钟1:4后分频
#define       T2_OUTPS_5            4    //TIMER2输入时钟1:5后分频
#define       T2_OUTPS_6            5    //TIMER2输入时钟1:6后分频
#define       T2_OUTPS_7            6    //TIMER2输入时钟1:7后分频
#define       T2_OUTPS_8            7    //TIMER2输入时钟1:8后分频
#define       T2_OUTPS_9            8    //TIMER2输入时钟1:9后分频
#define       T2_OUTPS_10           9    //TIMER2输入时钟1:10后分频
#define       T2_OUTPS_11           10   //TIMER2输入时钟1:11后分频
#define       T2_OUTPS_12           11   //TIMER2输入时钟1:12后分频
#define       T2_OUTPS_13           12   //TIMER2输入时钟1:13后分频
#define       T2_OUTPS_14           13   //TIMER2输入时钟1:14后分频
#define       T2_OUTPS_15           14   //TIMER2输入时钟1:15后分频
#define       T2_OUTPS_16           15   //TIMER2输入时钟1:16后分频

void GPIO_Init(void);
void Timer2_div(unsigned char T2_CKPS,unsigned char T2_OUTPS);
void Timer2_Init(void);

//==============================================================================================
// ----Function: 主程序
// --Parameters: None
// -----Returns: None
//---------Note: 选择Timer2预分频值为8和后分频值为4
//==============================================================================================

void main (void)
{
	GPIO_Init();     //所有IO初始化

	IPEN = 0;	   	//禁止中断优先级
	PEIE = 1;    	//外设GIEL
	GIE = 1;     	//全局GIEH
	Timer2_Init();    //timer2 配置初始化

	//			预分频1:8     后分频1:4
	Timer2_div(T2_CKPS_8,   T2_OUTPS_4);     //可根据需求配置预分频值与后分频值
	TMR2ON=1;   //使能timer2计数
	while(1);

}


//高优先级中断服务函数
void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断
	if(TMR2IF  &&  TMR2IE)      //f = 250Hz
	{
		TMR2IF = 0;		 //timer2中断标志位清0
	    PB3    =~PB3;		//PB3翻转
	}

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//进入中断后系统自动关闭中断

}

/*******************************************************************************
// ----Function: GPIO_Init
// --Parameters:
// -----Returns: None
//---------Note:所有IO初始化
*******************************************************************************/

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA输出模式
	TRISB = 0X00;   //PB输出模式

	PORTA = 0X00;	//PORTA输出0
	PORTB = 0X00;	//PORTB输出0

	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉

	PAOD = 0X00;    //关PA开漏输出
	PBOD = 0X00;    //关PB开漏输出

	ANASEL0 = 0X00; //关PA模拟量通道
	ANASEL1 = 0X00; //关PB模拟量通道
}

/*******************************************************************************
 * 【T2_CKPS】:TIMER1的输入时钟分频
 *                    T2_CKPS_1    TIMER1输入时钟1:1分频
 *                    T2_CKPS_4    TIMER1输入时钟1:4分频
 *                    T2_CKPS_8    TIMER1输入时钟1:8分频
 *                    T2_CKPS_16   TIMER1输入时钟1:16分频
 * 【T2_OUTPS】: TIMER1的输入时钟后分频
 				T2_OUTPS_1            0    //TIMER2输入时钟1:1后分频
		    	T2_OUTPS_2            1    //TIMER2输入时钟1:2后分频
		        T2_OUTPS_3            2    //TIMER2输入时钟1:3后分频
        		T2_OUTPS_4            3    //TIMER2输入时钟1:4后分频
				T2_OUTPS_5            4    //TIMER2输入时钟1:5后分频
		        T2_OUTPS_6            5    //TIMER2输入时钟1:6后分频
		        T2_OUTPS_7            6    //TIMER2输入时钟1:7后分频
		        T2_OUTPS_8            7    //TIMER2输入时钟1:8后分频
		        T2_OUTPS_9            8    //TIMER2输入时钟1:9后分频
		        T2_OUTPS_10           9    //TIMER2输入时钟1:10后分频
		        T2_OUTPS_11           10   //TIMER2输入时钟1:11后分频
		        T2_OUTPS_12           11   //TIMER2输入时钟1:12后分频
		        T2_OUTPS_13           12   //TIMER2输入时钟1:13后分频
		        T2_OUTPS_14           13   //TIMER2输入时钟1:14后分频
		        T2_OUTPS_15           14   //TIMER2输入时钟1:15后分频
		        T2_OUTPS_16           15   //TIMER2输入时钟1:16后分频
*******************************************************************************/
void Timer2_div(unsigned char T2_CKPS,unsigned char T2_OUTPS)
{

	T2CON |= T2_CKPS << 0;   //预分频
	T2CON |= T2_OUTPS<< 3;   //后分频
	TMR2IF = 0;      //清中断标志
	TMR2IP = 1;		 //高优先级中断
	TMR2IE = 1;      //开TMR2中断
}
/*******************************************************************************
// ----Function: Timer2_Init
// --Parameters:
// -----Returns: None
//---------Note:所有IO初始化
*******************************************************************************/
void Timer2_Init(void)
{
	PR2H = 0X03;    //周期
	PR2L = 0XE8;
	TMR2H  = 0X00;	//初值
	TMR2L  = 0X00;
}
